<?php
if ( !class_exists( 'UixShortcodes' ) ) {
    return;
}

/**
 * Note: 
 *
 * Please refer to sample:  uix_sc_module_sample_hello.php
 * 						    uix_sc_module_sample_hello2.php
 *
 * 1) For all ID attribute, special characters are only allowed underscores "_"
 * 2) Optional params of field "callback":  html, html-shortcode, attr, slug, url, number, number-deg_px, color-name, list, source-code
 * 3) String of clone trigger ID, must contain at least "_triggerclonelist"
 * 4) String of clone ID attribute must contain at least "_listitem"
 * 5) If multiple columns are used to clone event and there are multiple clone triggers, 
      the triggers ID and clone controls ID must contain the string "_one_", "_two", "_three_" or "_four_" for per column
*/

/**
 * Returns current module(form group) ID
 * ----------------------------------------------------
 */
$form_id = basename( __FILE__, '.php' );


/**
 * Form Type & Controls
 * ----------------------------------------------------
 */
$form_type = array(
    'list' => false
);


$args = 
	array(
	

	
		array(
			'id'             => 'uix_sc_share_btn_name',
			'title'          => esc_html__( 'Choose Type of Button', 'uix-shortcodes' ),
			'desc'           => '',
			'value'          => '1,2,3', //It takes a variable like '1,3'  if the value is empty.
			'placeholder'    => '',
			'type'           => 'multiselect',
			'default'        => array(
									'1'  => 'facebook',
									'2'  => 'twitter',
									'3'  => 'google_plus',
									'4'  => 'pinterest'
	
				                )
		
		
		),
	
		array(
			'id'             => 'uix_sc_share_btn_fillet',
			'title'          => esc_html__( 'Fillet Radius', 'uix-shortcodes' ),
			'desc'           => '',
			'value'          => 25,
			'placeholder'    => '',
			'type'           => 'short-text',
		    'callback'       => 'number',
			'default'        => array(
									'units'  => 'px'
								)
		
		),	
		
		
		
		array(
			'id'             => 'uix_sc_share_btn_color',
			'title'          => esc_html__( 'Button Color', 'uix-shortcodes' ),
			'desc'           => '',
			'value'          => 1,
			'placeholder'    => '',
			'type'           => 'radio',
			'default'        => array(
									'1'  => 'black',
									'2'  => 'multicolor'
								)
		
		),

		array(
			'id'             => 'uix_sc_share_btn_size',
			'title'          => esc_html__( 'Button Size', 'uix-shortcodes' ),
			'desc'           => '',
			'value'          => 1,
			'placeholder'    => '',
			'type'           => 'radio',
			'default'        => array(
									'1'  => 'small',
									'2'  => 'large'
								)
		
		),
		
	    array(
			'id'             => 'uix_sc_share_btn_tip',
			'desc'           => esc_html__( 'It takes that unique url and share it on the social page automagically.', 'uix-shortcodes' ),
			'type'           => 'note',
			'default'        => array(
		                            'fullwidth'  => false,
									'type'       => 'default'  //error, success, warning, note, default
				                ),
		
		),

		
	
	)
;


/**
 * Returns form
 * ----------------------------------------------------
 */
UixSCFormCore::form_scripts( array(
	    'clone'                   => false,
		'form_id'                 => $form_id,
		'fields'                  => array(
										array(
											 'type'    => $form_type,
											 'values'  => $args
										),

									),
		'title'                   => esc_html__( 'Share Buttons', 'uix-shortcodes' ),
	
		/**
		 * /////////////// Customizing HTML output on the frontend /////////////// 
		 * 
		 * 
		 * Usage:
		 *
		 * 1) Written as pure HTML syntax.
		 * 2) Directly use the controls ID as a variable: ${???}
		 * 3) Using {{if}} and {{else}} to render conditional sections. 
		       -----E.g.
		       {{if your_field_id}} ... {{else}} ... {{/if}}
			   
		 * 4) Using {{each}} to render repeating sections.
		       -----E.g.
				{{each your_clone_trigger_id}}
					{{if your_listitem_field_id != ""}}
					    {{if $index == 0}}<li class="active">{{else}}<li>{{/if}}
						    ${your_listitem_field_id}
						</li>
					{{/if}}	
				{{/each}}
		 
		 */
	    'template'              => '
		
		   [uix_share_buttons color=\'${uix_sc_share_btn_color}\' size=\'${uix_sc_share_btn_size}\' fillet=\'${uix_sc_share_btn_fillet}px\' show=\'{{if uix_sc_share_btn_name.indexOf( "1" ) >= 0}}facebook,{{/if}}{{if uix_sc_share_btn_name.indexOf( "2" ) >= 0}}twitter,{{/if}}{{if uix_sc_share_btn_name.indexOf( "3" ) >= 0}}google_plus,{{/if}}{{if uix_sc_share_btn_name.indexOf( "4" ) >= 0}}pinterest,{{/if}}\']

		'
	
    )
);

