<?php
if ( !class_exists( 'UixShortcodes' ) ) {
    return;
}

/**
 * Note: 
 *
 * Please refer to sample:  uix_sc_module_sample_hello.php
 * 						    uix_sc_module_sample_hello2.php
 *
 * 1) For all ID attribute, special characters are only allowed underscores "_"
 * 2) Optional params of field "callback":  html, html-shortcode, attr, slug, url, number, number-deg_px, color-name, list, source-code
 * 3) String of clone trigger ID, must contain at least "_triggerclonelist"
 * 4) String of clone ID attribute must contain at least "_listitem"
 * 5) If multiple columns are used to clone event and there are multiple clone triggers, 
      the triggers ID and clone controls ID must contain the string "_one_", "_two", "_three_" or "_four_" for per column
*/


/**
 * Returns current module(form group) ID
 * ----------------------------------------------------
 */
$form_id = basename( __FILE__, '.php' );


/**
 * Clone parameters
 * ----------------------------------------------------
 */
$clone_trigger_id        = 'uix_sc_portfolio_grid_triggerclonelist';  // String of clone trigger ID, must contain at least "_triggerclonelist"
$clone_max               = 30;                               // Maximum of clone form 


/**
 * Form Type & Controls
 * ----------------------------------------------------
 */
$form_type = array(
	'list' => false
);
					


$args = 
	array(
	
		
		array(
			'id'             => 'uix_sc_portfolio_grid_config_grid',
			'title'          => esc_html__( 'Column', 'uix-shortcodes' ),
			'desc'           => '',
			'value'          => 3,
			'placeholder'    => '',
			'type'           => 'radio',
			'default'        => array(
									'4'  => '4',
									'3'  => '3',
									'2'  => '2',
								)
		
		),	
		
		array(
			'id'             => 'uix_sc_portfolio_grid_config_thumbnail_fillet',
			'title'          => esc_html__( 'Radius of Fillet Image', 'uix-shortcodes' ),
			'desc'           => '',
			'value'          => 0,
			'placeholder'    => '',
			'type'           => 'short-text',
			'callback'       => 'number',
			'default'        => array(
									'units'  => '%'
								)
		
		),	
	
		array(
			/*
			 * @template vars: 
			 *
				${uix_sc_portfolio_grid_config_class_prefix}
				${uix_sc_portfolio_grid_config_class_prefix_attr}
			 *
			*/
			'id'             => 'uix_sc_portfolio_grid_config_class_prefix',
			'title'          => esc_html__( 'Class Prefix', 'uix-shortcodes' ),
			'desc'           => wp_kses( __( 'Prefix string attached to the classes of all elements generated by the portfolio, the default value is &quot;<strong>uix-sc-portfolio-</strong>&quot;.', 'uix-shortcodes' ), wp_kses_allowed_html( 'post' ) ),
			'value'          => 'uix-sc-portfolio-',
			'placeholder'    => '',
			'type'           => 'text',
		    'callback'       => 'attr',
		
		),	
		
		
		array(
			'id'             => 'uix_sc_portfolio_grid_config_filterable',
			'title'          => esc_html__( 'Filterable by Category', 'uix-shortcodes' ),
			'desc'           => '',
			'value'          => 0, // 0:false  1:true
			'placeholder'    => '',
			'type'           => 'checkbox'
		
		
		),	
		
		array(
			'id'             => 'uix_sc_portfolio_grid_config_urlwindow',
			'title'          => esc_html__( 'Open link in new tab', 'uix-shortcodes' ),
			'desc'           => esc_html__( 'This option is valid when you use destination URL.', 'uix-shortcodes' ),
			'value'          => 0, // 0:false  1:true
			'placeholder'    => '',
			'type'           => 'checkbox'
		
		
		),	
		

		
		
		//------ Clone controls list (begin)

		
		array(
			'id'             => $clone_trigger_id,
			'title'          => esc_html__( 'List Item', 'uix-shortcodes' ),
			'desc'           => '',
			'value'          => '',
			'placeholder'    => '',
			'type'           => 'list',
			'default'        => array(
									'max' => $clone_max
				                )
									
		),
	
		
			array(
				'id'             => 'uix_sc_portfolio_grid_listitem_thumbnail',
				'title'          => '',
				'desc'           => '',
				'value'          => '',
				'placeholder'    => esc_html__( 'Thumbnail', 'uix-shortcodes' ),
				'type'           => 'image'
			
			),	
		
			array(
				'id'             => 'uix_sc_portfolio_grid_listitem_fullimage',
				'title'          => '',
				'desc'           => '',
				'value'          => '',
				'placeholder'    => esc_html__( 'Full Preview (Optional)', 'uix-shortcodes' ),
				'type'           => 'image'
			
			),			
		
			array(
				/*
				 * @template vars: 
				 *
					${uix_sc_portfolio_grid_listitem_title}
					${uix_sc_portfolio_grid_listitem_title_attr}
				 *
				*/
				'id'             => 'uix_sc_portfolio_grid_listitem_title',
				'title'          => '',
				'desc'           => '',
				'value'          => esc_html__( 'Project Title', 'uix-shortcodes' ),
				'placeholder'    => '',
				'type'           => 'text',
			    'callback'       => 'attr',
			
			),			
			
			array(
				/*
				 * @template vars: 
				 *
					${uix_sc_portfolio_grid_listitem_cat}
					${uix_sc_portfolio_grid_listitem_cat_attr}
				 *
				*/
				'id'             => 'uix_sc_portfolio_grid_listitem_cat',
				'title'          => '',
				'desc'           => '',
				'value'          => esc_html__( 'Category', 'uix-shortcodes' ),
				'placeholder'    => '',
				'type'           => 'text',
			    'callback'       => 'attr',
			
			),			
			array(
				'id'             => 'uix_sc_portfolio_grid_listitem_intro',
				'title'          => '',
				'desc'           => '',
				'value'          => esc_html__( 'The description of this project.', 'uix-shortcodes' ),
				'placeholder'    => '',
				'type'           => 'textarea',
			    'callback'       => 'html',
				'default'        => array(
										'row'     => 5
									)
			
			),
		
		
			//--- Toggle of unidirectional display (begin)
			array(
				'id'             => 'uix_sc_portfolio_grid_listitem_toggle',
				'title'          => '',
				'desc'           => '',
				'value'          => 0, // 0:close  1:open
				'placeholder'    => '',
				'type'           => 'toggle',
				'toggle'         => array(
										'btn_text'      => esc_html__( 'set up links with toggle', 'uix-shortcodes' ),
										'target_ids'    => array( 'uix_sc_portfolio_grid_listitem_toggle_url' )
									)
			
			),	
	
				array(
					'id'             => 'uix_sc_portfolio_grid_listitem_toggle_url',
					'title'          => '',
					'desc'           => '',
					'value'          => '',
					'placeholder'    => esc_html__( 'Destination URL', 'uix-shortcodes' ),
					'type'           => 'text',
			        'callback'       => 'url',
				
				),
				
		
		    //--- Toggle of unidirectional display (end)
		
		
		
			
		
		//------ Clone controls list (end)
		

		
	
	)
;

/**
 * Returns form
 * ----------------------------------------------------
 */

/**
 * 
 * Returns the unique ID used in the frontend template
 */
$frontend_id = uniqid();


UixSCFormCore::form_scripts( array(
		'clone'                    => array(
												'trigger_id'     => $clone_trigger_id,
												'fields'         => array( 
																		'uix_sc_portfolio_grid_listitem_thumbnail', 
																		'uix_sc_portfolio_grid_listitem_fullimage',
																		'uix_sc_portfolio_grid_listitem_title',
																		'uix_sc_portfolio_grid_listitem_cat',
																		'uix_sc_portfolio_grid_listitem_intro',
																		'uix_sc_portfolio_grid_listitem_toggle',
																		'uix_sc_portfolio_grid_listitem_toggle_url',
																	)
											),
		'form_id'                 => $form_id,
		'fields'                  => array(
										array(
											 'type'    => $form_type,
											 'values'  => $args
										),

									),
		'title'                   => esc_html__( 'Portfolio', 'uix-shortcodes' ),
	
			/**
		 * /////////////// Customizing HTML output on the frontend /////////////// 
		 * 
		 * 
		 * Usage:
		 *
		 * 1) Written as pure HTML syntax.
		 * 2) Directly use the controls ID as a variable: ${???}
		 * 3) Using {{if}} and {{else}} to render conditional sections. 
		       -----E.g.
		       {{if your_field_id}} ... {{else}} ... {{/if}}
			   
		 * 4) Using {{each}} to render repeating sections.
		       -----E.g.
				{{each your_clone_trigger_id}}
					{{if your_listitem_field_id != ""}}
					    {{if $index == 0}}<li class="active">{{else}}<li>{{/if}}
						    ${your_listitem_field_id}
						</li>
					{{/if}}	
				{{/each}}
		 
		 */
	    'template'              => '
		
			[uix_portfolio filterable=\'${uix_sc_portfolio_grid_config_filterable}\' classprefix=\'${uix_sc_portfolio_grid_config_class_prefix_attr}\' col=\'${uix_sc_portfolio_grid_config_grid}\' imagefillet=\'${uix_sc_portfolio_grid_config_thumbnail_fillet}%\']

				<!-- loop start -->

					{{each '.$clone_trigger_id.'}}
						<br>[uix_portfolio_item type=\'${uix_sc_portfolio_grid_listitem_cat_attr}\' title=\'${uix_sc_portfolio_grid_listitem_title_attr}\' image=\'${uix_sc_portfolio_grid_listitem_thumbnail}\' fullimage=\'${uix_sc_portfolio_grid_listitem_fullimage}\' target=\'${uix_sc_portfolio_grid_config_urlwindow}\' url=\'${uix_sc_portfolio_grid_listitem_toggle_url}\']
						<br>[uix_portfolio_item_desc]${uix_sc_portfolio_grid_listitem_intro}[/uix_portfolio_item_desc]				
						<br>[/uix_portfolio_item]
					{{/each}}	

				<!-- loop end -->

			<br>[/uix_portfolio]
		
		'

    )
);

