<?php

/**
 * The file contains the class defining sharing networks and their sharer urls
 *
 * @since      1.0.0
 *
 */

/**
 * This class defines sharing networks and their sharer urls
 *
 * @since      1.0.0
 *
 */
class Sassy_Social_Share_Sharing_Networks {
	/**
	 * Options saved in database.
	 *
	 * @since    2.4
	 */
	private $options;

	/**
	 * Supported Social sharing networks
	 *
	 * @since    1.0.0
	 */
	private $sharing_networks = array(
		'facebook_share' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_%network%">%like_count_container%<div class="fb-share-button" data-href="%post_url%" data-layout="button_count"></div></li>',
		'facebook_like' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_%network%">%like_count_container%<div class="fb-like" data-href="%post_url%" data-layout="button_count" data-action="like" data-show-faces="false" data-share="false"></div></li>',
		'facebook_recommend' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_%network%">%like_count_container%<div class="fb-like" data-href="%post_url%" data-layout="button_count" data-action="recommend" data-show-faces="false" data-share="false"></div></li>',
		'twitter_tweet' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_%network%" heateor-sss-data-href="%post_url%">%like_count_container%<a href="https://twitter.com/share" class="twitter-share-button" data-url="%post_url%" data-counturl="%post_url%" data-text="%decoded_post_title%" data-via="%twitter_username%" data-lang="%language%" >Tweet</a><script>!function(d,s,id) {var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?"http":"https";if ( !d.getElementById(id) ) {js=d.createElement(s);js.id=id;js.src=p+"://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document, "script", "twitter-wjs");</script></li>',
		'google_plusone' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_%network%">%like_count_container%<script type="text/javascript" src="https://apis.google.com/js/platform.js">{lang: "%language%"}</script><div class="g-plusone" data-size="medium" data-href="%post_url%" data-callback="heateorSsmiGpCallback"></div></li>',
		'google_plus_share' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_%network%">%like_count_container%<script type="text/javascript" src="https://apis.google.com/js/platform.js">{lang: "%language%"}</script><div class="g-plus" data-action="share" data-annotation="bubble" data-href="%post_url%"></div></li>',
		'linkedin_share' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_%network%">%like_count_container%<script src="//platform.linkedin.com/in.js" type="text/javascript">lang: %language%</script><script type="IN/Share" data-url="%post_url%" data-counter="right"></script></li>',
		'pinterest_pin' => '<li style="padding:1.35px 0 !important" class="heateor_sss_%network%">%like_count_container%<a data-pin-lang="%language%" href="//www.pinterest.com/pin/create/button/?url=%post_url%" data-pin-do="buttonPin" data-pin-config="beside"><img src="//assets.pinterest.com/images/pidgets/pinit_fg_en_rect_gray_20.png" /></a><script type="text/javascript" async src="//assets.pinterest.com/js/pinit.js"></script></li>',
		'buffer_share' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_%network%">%like_count_container%<a href="http://bufferapp.com/add" class="buffer-add-button" data-text="%post_title%" data-url="%post_url%" data-count="horizontal" data-via="%buffer_username%" ></a><script type="text/javascript" src="https://d389zggrogs7qo.cloudfront.net/js/button.js"></script></li>',
		'xing_share' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_xing">%like_count_container%<div data-type="XING/Share" data-counter="right" data-url="%post_url%" data-lang="%language%"></div><script>(function (d, s) {var x = d.createElement(s), s = d.getElementsByTagName(s)[0]; x.src = "https://www.xing-share.com/js/external/share.js"; s.parentNode.insertBefore(x, s); })(document, "script");</script></li>',
		'yummly_share' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_yummly">%like_count_container%<a href="//yummly.com" class="YUMMLY-YUM-BUTTON">Yum</a><script src="https://www.yummly.com/js/widget.js?general"></script></li>',
		'reddit_badge' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_reddit">%like_count_container%<script type="text/javascript" src="//www.reddit.com/static/button/button1.js"></script></li>',
		'stumbleupon_badge' => '<li style="padding:%padding%px 0 !important" class="heateor_sss_stumbleupon">%like_count_container%<su:badge layout="1" location="%post_url%"></su:badge><script type="text/javascript">(function() {var li = document.createElement(\'script\' ); li.type = \'text/javascript\'; li.async = true;li.src = (\'https:\' == document.location.protocol ? \'https:\' : \'http:\' ) + \'//platform.stumbleupon.com/1/widgets.js\';var s = document.getElementsByTagName(\'script\' )[0]; s.parentNode.insertBefore(li, s);})();</script></li>',
		'facebook' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.facebook.com/sharer/sharer.php?u=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'twitter' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://twitter.com/intent/tweet?%via_twitter_username%text=%wpseo_post_title%&url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'linkedin' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.linkedin.com/shareArticle?mini=true&url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'google_plus' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://plus.google.com/share?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'print' => '<li class="%li_class%"><i %style% alt="%title%" Title="Print" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'window.print()\'><ss style="display:block" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'email' => '<li class="%li_class%"><i %style% alt="%title%" Title="Email" class="heateorSssSharing heateorSss%ucfirst_network%Background" %amp_email% onclick="window.location.href = \'mailto:?subject=\' + decodeURIComponent(\'%post_title%\' ).replace(\'&\', \'%26\') + \'&body=\' + decodeURIComponent(\'%encoded_post_url%\' )"><ss style="display:block" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'yahoo' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://bookmarks.yahoo.com/toolbar/SaveBM/?u=%encoded_post_url%&t=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'reddit' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://reddit.com/submit?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'digg' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://digg.com/submit?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'delicious' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://del.icio.us/post?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'stumbleupon' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.stumbleupon.com/submit?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'float_it' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.designfloat.com/submit.php?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'tumblr' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.tumblr.com/share?v=3&u=%encoded_post_url%&t=%post_title%&s=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'vkontakte' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://vkontakte.ru/share.php?&url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'pinterest' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick="javascript:void( (function() {var e=document.createElement(\'script\' );e.setAttribute(\'type\',\'text/javascript\' );e.setAttribute(\'charset\',\'UTF-8\' );e.setAttribute(\'src\',\'//assets.pinterest.com/js/pinmarklet.js?r=\'+Math.random()*99999999);document.body.appendChild(e)})());"><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'xing' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.xing-share.com/social_plugins/share?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'whatsapp' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background"><a %amp_whatsapp% href="whatsapp://send?text=%post_title% %encoded_post_url%" rel="nofollow"><ss style="display:block" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></a></i></li>',
		'instagram' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background"><a href="https://www.instagram.com/%instagram_username%" target="_blank"><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></a></i></li>',
		'yummly' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.yummly.com/urb/verify?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'buffer' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://buffer.com/add?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'AIM' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://lifestream.aol.com/?url=%%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Amazon_Wish_List' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.amazon.com/wishlist/add?u=%encoded_post_url%&t=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'AOL_Mail' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://webmail.aol.com/25045/aol/en-us/Mail/compose-message.aspx?subject=%post_title%&body=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'App.net' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://account.app.net/login/")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Baidu' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://cang.baidu.com/do/add?it=%post_title%&iu=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Balatarin' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.balatarin.com/login")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'BibSonomy' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.bibsonomy.org/login")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Bitty_Browser' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.bitty.com/manual/?contenttype=&contentvalue=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Blinklist' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://blinklist.com/blink?t=%post_title%&d=&u=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Blogger_Post' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.blogger.com/blog_this.pyra?t&u=%encoded_post_url%&l&n=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'BlogMarks' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://blogmarks.net/my/new.php?mini=1&simple=1&title=%post_title%&url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Bookmarks.fr' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.bookmarks.fr/Connexion/?action=add&address=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Box.net' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.box.com/api/1.0/import?url=%encoded_post_url%&name=%post_title%&description=&import_as=link")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'BuddyMarks' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://buddymarks.com/login.php?bookmark_title=%post_title%&bookmark_url=%encoded_post_url%&bookmark_desc=&bookmark_tags=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Care2_News' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.care2.com/passport/login.html?promoID=10&pg=http://www.care2.com/news/compose?sharehint=news&share[share_type]news&bookmarklet=Y&share[title]=%post_title%&share[link_url]=%encoded_post_url%&share[content]=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'CiteULike' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.citeulike.org/posturl?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Comment' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background"><a href="#%comment_container_id%" rel="nofollow"><ss style="display:block" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></a></i></li>',
		'Copy_Link' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background"><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Diary.Ru' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.diary.ru/?newpost&title=%post_title%&text=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Diaspora' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://joindiaspora.com/bookmarklet?url=%encoded_post_url%&title=%post_title%&v=1&")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'diHITT' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.dihitt.com/submit?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Diigo' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.diigo.com/post?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Draugiem' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.draugiem.lv/say/ext/add.php?link=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Douban' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.douban.com/share/service?name=%post_title%&href=%encoded_post_url%&image=&updated=&bm=&url=%encoded_post_url%&title=%post_title%&sel=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'DZone' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.dzone.com/links/add.html?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Evernote' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.evernote.com/clip.action?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Facebook_Messenger' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.facebook.com/dialog/send?app_id=1904103319867886&display=popup&link=%encoded_post_url%&redirect_uri=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Fark' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.fark.com/submit?new_url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Flipboard' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://share.flipboard.com/bookmarklet/popout?v=2&url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Folkd' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.folkd.com/page/social-bookmarking.html?addurl=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Google_Bookmarks' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.google.com/bookmarks/mark?op=edit&bkmk=%encoded_post_url%&title=%post_title%&annotation=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Google_Classroom' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://classroom.google.com/u/0/share?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Google_Gmail' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://mail.google.com/mail/?ui=2&view=cm&fs=1&tf=1&su=%post_title%&body=Link:%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Hacker_News' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://news.ycombinator.com/submitlink?u=%encoded_post_url%&t=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Hatena' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://b.hatena.ne.jp/bookmarklet?url=%encoded_post_url%&btitle=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Instapaper' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.instapaper.com/edit?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Jamespot' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//my.jamespot.com/")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Kakao' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://story.kakao.com/share?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Kik' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.kik.com/send/article/?app_name=Share&text=&title=%post_title%&url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Kindle_It' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//fivefilters.org/kindle-it/send.php?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Known' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://withknown.com/share/?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Line' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background"><a href="line://msg/text/%post_title%! %encoded_post_url%"><ss style="display:block" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></a></i></li>',
		'LiveJournal' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.livejournal.com/update.bml?subject=%post_title%&event=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Mail.Ru' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://connect.mail.ru/share?share_url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Mendeley' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.mendeley.com/sign-in/")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Meneame' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.meneame.net/submit.php?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Mixi' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://mixi.jp/share.pl?mode=login&u=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'MySpace' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'var heateorSssMyspaceShareUrl = "https://myspace.com/post?u=" + encodeURIComponent("%encoded_post_url%") +  "&t=%post_title%&l=3&c=%post_title%";heateorSssPopup(heateorSssMyspaceShareUrl)\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Netlog' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.netlog.com/go/manage/links/view=save&origin=external&url=%encoded_post_url%&title=%post_title%&description=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Netvouz' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.netvouz.com/action/submitBookmark?url=%encoded_post_url%&title=%post_title%&popup=no&description=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'NewsVine' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.newsvine.com/_tools/seed?popoff=0&u=%encoded_post_url%&h=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'NUjij' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.nujij.nl/nieuw-bericht.2051051.lynkx?title=%post_title%&url=%encoded_post_url%&bericht=&topic=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Odnoklassniki' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://connect.ok.ru/dk?cmd=WidgetSharePreview&st.cmd=WidgetSharePreview&st.shareUrl=%encoded_post_url%&st.client_id=-1")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Oknotizie' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//oknotizie.virgilio.it/post?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Outlook.com' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://mail.live.com/default.aspx?rru=compose?subject=%post_title%&body=%encoded_post_url%&lc=1033&id=64855&mkt=en-us&cbcxt=mai")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Papaly' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://papaly.com/api/share.html?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Pinboard' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://pinboard.in/popup_login/?url=%encoded_post_url%&title=%post_title%&later=&description=&next=same")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Plurk' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//www.plurk.com/m?content=%encoded_post_url%&qualifier=shares")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Pocket' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://readitlaterlist.com/save?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Polyvore' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick="javascript:(function(){function e(a){var c=window;if(c.PolyvoreClipper){c.PolyvoreClipper.run()}else{var b=a.createElement(\'script\');c._polyvoreMode=\'prod\';c._polyvoreHost=\'www.polyvore.com\';b.src=\'http://akwww.polyvorecdn.com/rsrc/clipper.js?\'+Math.floor((new Date()).getTime()/86400000);a.body.appendChild(b)}}try{e(document)}catch(g){}for(var f=0;f<frames.length;++f){var i=frames[f];try{if(i.frameElement.tagName==\'IFRAME\'){continue}if(i.innerWidth<400||i.innerHeight<400){continue}e(i.document)}catch(j){}}})();"><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'PrintFriendly' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.printfriendly.com/print?url=%encoded_post_url%&partner=a2a")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Protopage_Bookmarks' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.protopage.com/add-button-site?url=%encoded_post_url%&label=&type=page")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Pusha' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//www.pusha.se/posta?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Qzone' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://sns.qzone.qq.com/cgi-bin/qzshare/cgi_qzshare_onekey?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Rediff MyPage' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//share.rediff.com/bookmark/addbookmark?bookmarkurl=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Refind' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://refind.com/?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Renren' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//www.connect.renren.com/share/sharer?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Segnalo' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://segnalo.virgilio.it/post.html.php?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Sina Weibo' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//service.weibo.com/share/share.php?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'SiteJot' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("http://www.sitejot.com/loginform.php?iSiteAdd=&iSiteDes=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Skype' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://web.skype.com/share?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Slashdot' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//slashdot.org/submission?url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'SMS' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background"><a href="sms://?&body=%post_title% %encoded_post_url%" rel="nofollow"><ss style="display:block" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></a></i></li>',
		'StockTwits' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://stocktwits.com/widgets/share?body=%post_title%%20%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Stumpedia' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//www.stumpedia.com/submit?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Svejo' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://svejo.net/story/submit_by_url?url=%encoded_post_url%&title=%post_title%&summary=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Symbaloo_Feeds' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//www.symbaloo.com/")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Telegram' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://telegram.me/share/url?url=%encoded_post_url%&text=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Trello' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://trello.com/add-card?mode=popup&url=%encoded_post_url%&name=%post_title%&desc=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Tuenti' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.tuenti.com/share?p=b5dd6602&url=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Twiddla' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//www.twiddla.com/New.aspx?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'TypePad_Post' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("https://www.typepad.com/services/quickpost/post?v=2&qp_show=ac&qp_title=%post_title%&qp_href=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Viadeo' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//www.viadeo.com/shareit/share/?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Viber' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background"><a href="viber://forward?text=%post_title% %encoded_post_url%" rel="nofollow"><ss style="display:block" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></a></i></li>',
		'Wanelo' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//wanelo.com/p/post?bookmarklet=&images%5B%5D=&url=%encoded_post_url%&title=%post_title%&price=&shop=")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Webnews' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//www.webnews.de/login")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'WordPress' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//www.addtoany.com/ext/wordpress/press_this?linkurl=%encoded_post_url%&linkname=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Wykop' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//www.wykop.pl/dodaj?url=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Yahoo_Mail' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//compose.mail.yahoo.com/?Subject=%post_title%&body=Link:%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Yahoo_Messenger' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("ymsgr:sendim?m=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'Yoolink' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//yoolink.to/addorshare?url_value=%encoded_post_url%&title=%post_title%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>',
		'YouMob' => '<li class="%li_class%"><i %style% alt="%title%" Title="%title%" class="heateorSssSharing heateorSss%ucfirst_network%Background" onclick=\'heateorSssPopup("//youmob.com/startmob.aspx?cookietest=true&mob=%encoded_post_url%")\'><ss style="%inner_style%" class="heateorSssSharingSvg heateorSss%ucfirst_network%Svg"></ss></i></li>'
	);

	/**
	 * Constructor
	 *
	 * @since    1.0.0
	 */
	public function __construct( $options ) {

		$this->options = $options;

	}

	/**
	 * Constructor
	 *
	 * @since    1.0.0
	 */
	public function fetch_sharing_networks() {
		
		$this->sharing_networks['instagram'] = str_replace( '%instagram_username%', $this->options['instagram_username'] != '' ? $this->options['instagram_username'] : $this->options['vertical_instagram_username'], $this->sharing_networks['instagram'] );
		$this->sharing_networks['Comment'] = str_replace( '%comment_container_id%', $this->options['comment_container_id'] != '' ? $this->options['comment_container_id'] : $this->options['vertical_comment_container_id'], $this->sharing_networks['Comment'] );
		return $this->sharing_networks;
	
	}

}
