<?php
/**
 * Plugin Name: Flickr Album Gallery Pro
 * Version: 1.4.1
 * Description: Flickr Album Gallery Pro fetch all your flickr account photo albums and you can publish individual or all flickr albums on your WrodPress site.
 * Author: Weblizar
 * Author URI: http://weblizar.com/plugins/flickr-gallery/
 * Plugin URI: http://weblizar.com/plugins/flickr-gallery/
 */
 
/**
 * Constant Variable
 */
define("FAGP_TEXT_DOMAIN", "weblizar_fag");
define("FAGP_PLUGIN_URL", plugin_dir_url(__FILE__));

/**
 * Flickr Album Gallery Pro Plugin Class
 */
 class FlickrAlbumGalleryPro {

	public function __construct() {
		if (is_admin()) {
			add_action('plugins_loaded', array(&$this, 'FAG_Translate'), 1);
			// 2
			add_action('init', array(&$this, 'FlickrAlbumGalleryPro_CPT'), 1);
			// 3
			add_action('add_meta_boxes', array(&$this, 'Add_all_fag_meta_boxes'));
            add_action('admin_init', array(&$this, 'Add_all_fag_meta_boxes'), 1);
			// 4
			add_action('save_post', array(&$this, 'Save_fag_meta_box_save'), 9, 1);
		}
	}
	
	/**
	 * Translate Plugin
	 */
	public function FAG_Translate() {
	 load_plugin_textdomain('weblizar_fag', FALSE, dirname( plugin_basename(__FILE__)).'/lang/' );
	}	
	
	// 2 - Register Flickr Album Custom Post Type
	public function FlickrAlbumGalleryPro_CPT() {
		$labels = array(
			'name' => _x( 'Flickr Album Gallery Pro', 'fagp_gallery' ),
			'singular_name' => _x( 'Flickr Album Gallery Pro', 'fagp_gallery' ),
			'add_new' => _x( 'Add New Gallery', 'fagp_gallery' ),
			'add_new_item' => _x( 'Add New Gallery', 'fagp_gallery' ),
			'edit_item' => _x( 'Edit Photo Gallery', 'fagp_gallery' ),
			'new_item' => _x( 'New Gallery', 'fagp_gallery' ),
			'view_item' => _x( 'View Gallery', 'fagp_gallery' ),
			'search_items' => _x( 'Search Galleries', 'fagp_gallery' ),
			'not_found' => _x( 'No galleries found', 'fagp_gallery' ),
			'not_found_in_trash' => _x( 'No galleries found in Trash', 'fagp_gallery' ),
			'parent_item_colon' => _x( 'Parent Gallery:', 'fagp_gallery' ),
			'all_items' => __( 'All Galleries', 'fagp_gallery' ),
			'menu_name' => _x( 'Flickr Album Gallery Pro', 'fagp_gallery' ),
		);

		$args = array(
			'labels' => $labels,
			'hierarchical' => false,
			'supports' => array( 'title', ),
			'public' => false,
			'show_ui' => true,
			'show_in_menu' => true,
			'menu_position' => 10,
			'menu_icon' => 'dashicons-format-gallery',
			'show_in_nav_menus' => false,
			'publicly_queryable' => false,
			'exclude_from_search' => true,
			'has_archive' => true,
			'query_var' => true,
			'can_export' => true,
			'rewrite' => false,
			'capability_type' => 'post'
		);

        register_post_type( 'fagp_gallery', $args );
        add_filter( 'manage_edit-fagp_gallery_columns', array(&$this, 'fagp_gallery_columns' )) ;
        add_action( 'manage_fagp_gallery_posts_custom_column', array(&$this, 'fagp_gallery_manage_columns' ), 10, 2 );
	}
	
	function fagp_gallery_columns( $columns ){
        $columns = array(
            'cb' => '<input type="checkbox" />',
            'title' => __( 'Flickr Album Title' ),
            'shortcode' => __( 'Copy Flickr Album Shortcode' ),
            'date' => __( 'Date' )
        );
        return $columns;
    }
	
    function fagp_gallery_manage_columns( $column, $post_id ){
        global $post;
        switch( $column ) {
          case 'shortcode' :
            echo '<input type="text" value="[FAGP id='.$post_id.']" readonly="readonly" />';
            break;
          default :
            break;
        }
    }
	
	// 3 - Meta Box Creator
	public function Add_all_fag_meta_boxes() {
		add_meta_box( __('Add Images', FAGP_TEXT_DOMAIN), __('Add Images', FAGP_TEXT_DOMAIN), array(&$this, 'fag_meta_box_form_function'), 'fagp_gallery', 'normal', 'low' );
		add_meta_box ( __('Flickr Album Gallery Pro Shortcode', FAGP_TEXT_DOMAIN), __('Copy Album Gallery Shortcode', FAGP_TEXT_DOMAIN), array(&$this, 'fag_shortcode_meta_box_form_function'), 'fagp_gallery', 'side', 'low');
		add_meta_box ( __('Flickr Album Gallery Pro Widget', FAGP_TEXT_DOMAIN), __('Flickr Album Gallery Pro Widget', FAGP_TEXT_DOMAIN), array(&$this, 'fag_shortcode_meta_box_widget_function'), 'fagp_gallery', 'side', 'low');
    }
    
    
	/**
	 * Widget Box
	 */
    function fag_shortcode_meta_box_widget_function(){
	?>
	<div>
		<p><?php _e("To activate widget into any widget area", FAGP_TEXT_DOMAIN);?></p>
		<p><a href="<?php get_site_url();?>./widgets.php" ><?php _e("Click Here", FAGP_TEXT_DOMAIN);?></a>. </p>
		<p><?php _e("Find",FAGP_TEXT_DOMAIN)?> <b><?php _e("Flickr Album Gallery Pro Widget", FAGP_TEXT_DOMAIN);?></b> <?php _e("and place it to your widget area. Select any Shortcode for the dropdown and save changes.", FAGP_TEXT_DOMAIN);?></p>
	</div>
	<?php
	}
    
	
	/**
	 * Shortcode Box
	 */
	public function fag_shortcode_meta_box_form_function() { ?>
		<p><?php _e("Use below shortcode in any Page/Post to publish your Flickr Album Gallery Pro", FAGP_TEXT_DOMAIN);?></p>
		<input readonly="readonly" type="text" value="<?php echo "[FAGP id=".get_the_ID()."]"; ?>"> <?php
	}
	
	/**
	 * Gallery Settings Meta Box Interface
	 */
	public function fag_meta_box_form_function($post) {
		// Add the color picker css file
		wp_enqueue_style( 'wp-color-picker' );
		// Custom jQuery with WordPress Color Picker dependency
		wp_enqueue_script( 'fagp-color-picker-script', FAGP_PLUGIN_URL.'js/fagp-color-picker.js', array( 'wp-color-picker' ), false, true );
		wp_enqueue_style('font-awesome-min-css', FAGP_PLUGIN_URL.'css/font-awesome-latest/css/font-awesome.min.css');
		require_once("flicker-album-gallery-pro-settings.php");
	}
	
	/**
	 * FAGP Meta Settings Save
	 */
	public function Save_fag_meta_box_save($PostID) {
		if(isset($_POST['FAGP_API_KEY']) && isset($_POST['FAGP_Album_ID'])) {
			$FAGP_API_KEY = trim($_POST['FAGP_API_KEY']);
			$FAGP_Album_ID = trim($_POST['FAGP_Album_ID']);
			$FAGP_Show_Title = $_POST['FAGP_Show_Title'];
			$FAGP_Light_Box = $_POST['FAGP_Light_Box'];
			$FAGP_Gallery_Layout = $_POST['FAGP_Gallery_Layout'];
			$FAGP_Thumbnail_Size = $_POST['FAGP_Thumbnail_Size'];
			$FAGP_Hover_Color = $_POST['FAGP_Hover_Color'];
			$FAGP_Hover_Color_Opacity = $_POST['FAGP_Hover_Color_Opacity'];
			$FAGP_Hover_Animation = $_POST['FAGP_Hover_Animation'];
			$FAGP_Thumbnail_Border = $_POST['FAGP_Thumbnail_Border'];
			$FAGP_Image_Limit = $_POST['FAGP_Image_Limit'];
			$FAGP_Lazy_Loading = $_POST['FAGP_Lazy_Loading'];
			$FAGP_Custom_CSS = $_POST['FAGP_Custom_CSS'];
			
			$FAGArray[] = array(
				'FAGP_API_KEY' => $FAGP_API_KEY,
				'FAGP_Album_ID' => $FAGP_Album_ID,
				'FAGP_Show_Title' => $FAGP_Show_Title,
				'FAGP_Light_Box' => $FAGP_Light_Box,
				'FAGP_Gallery_Layout' => $FAGP_Gallery_Layout,
				'FAGP_Thumbnail_Size' => $FAGP_Thumbnail_Size,
				'FAGP_Hover_Color' => $FAGP_Hover_Color,
				'FAGP_Show_Title' => $FAGP_Show_Title,
				'FAGP_Hover_Color_Opacity' => $FAGP_Hover_Color_Opacity,
				'FAGP_Hover_Animation' => $FAGP_Hover_Animation,
				'FAGP_Thumbnail_Border' => $FAGP_Thumbnail_Border,
				'FAGP_Image_Limit' => $FAGP_Image_Limit,
				'FAGP_Lazy_Loading' => $FAGP_Lazy_Loading,
				'FAGP_Custom_CSS' => $FAGP_Custom_CSS,
			);
			
			update_post_meta($PostID, 'fagp_settings', serialize($FAGArray));
		}
	}
}// end of class

global $FlickrAlbumGalleryPro;
$FlickrAlbumGalleryPro = new FlickrAlbumGalleryPro();
require_once("flickr-album-gallery-widget.php"); 


/**
 * Flickr Album Gallery Pro Shortcode Detect Function
 */
function FlickrAlbumGalleryProShortCodeDetect() {
    /* global $wp_query;
    $Posts = $wp_query->posts;
    $Pattern = get_shortcode_regex();

    foreach ($Posts as $Post) {
        //if (   preg_match_all( '/'. $Pattern .'/s', $Post->post_content, $Matches ) && array_key_exists( 2, $Matches ) && in_array( 'FAGP', $Matches[2] ) ) {
		if ( strpos($Post->post_content, 'FAGP' ) ) { */
			
			//JS
			wp_enqueue_script('jquery');
            //wp_enqueue_script('fagp-jquery-min-js',FAGP_PLUGIN_URL.'js/jquery.min.js', array('jquery'));
			wp_enqueue_script( 'fagp-bootstrap-min-js', plugins_url('js/bootstrap.min.js', __FILE__ ), array('jquery'), false, true );
			wp_enqueue_script('fagp-hover-pack-js',FAGP_PLUGIN_URL.'js/hover-pack.js', array('jquery'));
			wp_enqueue_script( 'fagp-imagesloaded-pkgd-min-js', plugins_url('js/imagesloaded.pkgd.min.js', __FILE__ ), array('jquery'), false, true );
			wp_enqueue_script( 'fagp-jquery-blueimp-gallery-min-js', plugins_url('js/jquery.blueimp-gallery.min.js', __FILE__ ), array('jquery'), false, true );
			wp_enqueue_script( 'fagp-bootstrap-image-gallery-min-js', plugins_url('js/bootstrap-image-gallery.min.js', __FILE__ ), array('jquery'), false, true );
			
			// 1- nivo js css
			wp_enqueue_style('fagp-nivo-lightbox-min-css', FAGP_PLUGIN_URL.'lightbox/nivo/nivo-lightbox.min.css');
			wp_enqueue_script('fagp-nivo-lightbox-min-js', FAGP_PLUGIN_URL.'lightbox/nivo/nivo-lightbox.min.js', array('jquery'));
			
			// 2 - photo box js css
			wp_enqueue_style('fagp-photobox-css', FAGP_PLUGIN_URL.'lightbox/photobox/photobox.css');
			wp_enqueue_script('fagp-photobox-js', FAGP_PLUGIN_URL.'lightbox/photobox/jquery.photobox.js', array('jquery'));
			
			//3 - pretty photo box js css
			wp_enqueue_style('fagp-pretty-css', FAGP_PLUGIN_URL.'lightbox/prettyphoto/prettyPhoto.css');
			wp_enqueue_script('fagp-pretty-js', FAGP_PLUGIN_URL.'lightbox/prettyphoto/jquery.prettyPhoto.js', array('jquery'));
			
			//window box js css
            wp_enqueue_style('fagp-windowbox-css', FAGP_PLUGIN_URL.'lightbox/windowbox/lightbox.css');
			wp_enqueue_script('fagp-windowbox-js', FAGP_PLUGIN_URL.'lightbox/windowbox/lightbox-2.6.min.js');
			
			//smooth box js css
            wp_enqueue_style('fagp-smoothbox-css', FAGP_PLUGIN_URL.'lightbox/smoothbox/smoothbox.css');
            
			
			//swipe box js css
            wp_enqueue_style('fagp-swipe-css', FAGP_PLUGIN_URL.'lightbox/swipebox/swipebox.css');
			wp_enqueue_script('fagp-swipe-js', FAGP_PLUGIN_URL.'lightbox/swipebox/jquery.swipebox.js');
			
			//ion box js css
            wp_enqueue_style('fagp-ionbox-css', FAGP_PLUGIN_URL.'lightbox/ionbox/ion.zoom.css');
			
			//fancy box js css
            wp_enqueue_style('fagp-fancybox-css', FAGP_PLUGIN_URL.'lightbox/fancybox/jquery.fancybox.css');
			wp_enqueue_script('fagp-fancybox-js', FAGP_PLUGIN_URL.'lightbox/fancybox/jquery.fancybox.js');
			
			//CSS
			wp_enqueue_style('fagp-bootstrap-min-css', FAGP_PLUGIN_URL.'css/bootstrap.css');
			wp_enqueue_style('fagp-blueimp-gallery-min-css', FAGP_PLUGIN_URL.'css/blueimp-gallery.min.css');
			wp_enqueue_style('fagp-site-css', FAGP_PLUGIN_URL.'css/site.css');
			wp_enqueue_style('fagp-img-gallery-css', FAGP_PLUGIN_URL.'css/fagp-gallery.css');
			wp_enqueue_style('fagp-hover-css', FAGP_PLUGIN_URL.'css/hover-pack.css');			
			
            /* break;
        } //end of if
    } //end of foreach */
}
add_action( 'wp', 'FlickrAlbumGalleryProShortCodeDetect' );

/**
 * Flickr Album Gallery Pro Short Code [FAGP]
 */
require_once("flickr-album-gallery-pro-short-code.php");

/**
 * Hex Color code to RGB Color Code converter function
 */
if(!function_exists('FAGPhex2rgb')) {
    function FAGPhex2rgb($hex) {
       $hex = str_replace("#", "", $hex);

       if(strlen($hex) == 3) {
          $r = hexdec(substr($hex,0,1).substr($hex,0,1));
          $g = hexdec(substr($hex,1,1).substr($hex,1,1));
          $b = hexdec(substr($hex,2,1).substr($hex,2,1));
       } else {
          $r = hexdec(substr($hex,0,2));
          $g = hexdec(substr($hex,2,2));
          $b = hexdec(substr($hex,4,2));
       }
       $rgb = array($r, $g, $b);
       return $rgb; // returns an array with the rgb values
    }
}

/**
 * Documentation Page
 */
add_action('admin_menu' , 'FAGP_DOC_Menu_Function');
function FAGP_DOC_Menu_Function() {
	add_submenu_page('edit.php?post_type=fagp_gallery', __('Need Help?', FAGP_TEXT_DOMAIN), __('Need Help?', FAGP_TEXT_DOMAIN), 'administrator', 'flickr-docs', 'FAG_DOC_Page_Function_weblizar');
}
function FAG_DOC_Page_Function_weblizar(){ 
	wp_enqueue_script('bootstrap-min-js', FAGP_PLUGIN_URL.'js/bootstrap.min.js');
	wp_enqueue_script('weblizar-tab-js', FAGP_PLUGIN_URL .'js/option-js.js',array('jquery', 'media-upload', 'jquery-ui-sortable'));
	wp_enqueue_style('weblizar-option-style-css', FAGP_PLUGIN_URL .'css/weblizar-option-style.css');
	wp_enqueue_style('op-bootstrap-css', FAGP_PLUGIN_URL. 'css/bootstrap.css');
	wp_enqueue_style('weblizar-bootstrap-responsive-google', FAGP_PLUGIN_URL .'css/bootstrap-responsive.css');
	wp_enqueue_style('font-awesome-min-css', FAGP_PLUGIN_URL.'css/font-awesome-latest/css/font-awesome.min.css');
	wp_enqueue_style('Respo-pricing-table-css', FAGP_PLUGIN_URL .'css/pricing-table-responsive.css');
	wp_enqueue_style('pricing-table-css', FAGP_PLUGIN_URL .'css/pricing-table.css');
	require_once("flicker-album-gallery-pro-help.php");
	
}	
	
/**
 * Flicker Album Gallery Shortcode Button in Page/Post
 */
add_action('media_buttons_context', 'add_fagp_custom_button');
add_action('admin_footer', 'add_fagp_inline_popup_content');

function add_fagp_custom_button($context) {
  $img = plugins_url( '/img/flickr.png' , __FILE__ );
  $container_id = 'FAGP';
  $title = 'Select Flickr Album Gallery to insert into post';
  $context .= '<a class="button button-primary thickbox" title="Select portfolio gallery to insert into post" href="#TB_inline?width=400&inlineId='.$container_id.'">
	<span class="wp-media-buttons-icon" style="background: url('.$img.'); background-repeat: no-repeat; background-position: left bottom;"></span>
	Flicker Album Gallery Shortcode
	</a>';
  return $context;
}

function add_fagp_inline_popup_content() { ?>
	<script type="text/javascript">
	jQuery(document).ready(function() {
		jQuery('#flickr-gallery-insert').on('click', function() {
			var id = jQuery('#fagp-gallery-select option:selected').val();
			window.send_to_editor('<p>[FAGP id=' + id + ']</p>');
			tb_remove();
		})
	});
	</script>

	<div id="FAGP" style="display:none;">
	<h3><?php _e('Select Flickr Album Gallery to insert into post', FAGP_TEXT_DOMAIN); ?></h3>
	<?php 
		$all_posts = wp_count_posts( 'fagp_gallery')->publish;
		$args = array('post_type' => 'fagp_gallery', 'posts_per_page' =>$all_posts);
		global $fagp_galleries;
		$fagp_galleries = new WP_Query( $args );		
		if( $fagp_galleries->have_posts() ) { ?>
			<select id="fagp-gallery-select">
				<?php
				while ( $fagp_galleries->have_posts() ) : $fagp_galleries->the_post(); ?>
				<option value="<?php echo get_the_ID(); ?>"><?php the_title(); ?></option>
				<?php
				endwhile; 
				?>
			</select>
			<button class='button primary' id='flickr-gallery-insert'><?php _e('Insert Album Shortcode', FAGP_TEXT_DOMAIN); ?></button>
		<?php
		} else {
			_e('No Album Gallery Found', FAGP_TEXT_DOMAIN);
		} 
	?>
	</div>
	<?php
}
?>